
union wkPtr {
	char					*Ptr;
	word					*wPtr;
	long					*lPtr;
};
typedef union wkPtr wkPtr;

word        mainResID, workResID, deskResID;
extern word moonIndex;
extern long moonTick, moonPhase[8];

/*--------------------------------------
    copyBundles

    Marc Wolfgram, 11/12/92 20:27:21
*/
{
long bundleCount, bundleIndex;

    SetCurResFile(workfileID);
    bundleCount = CountResources(rBundle);
    for (bundleIndex = 0L; bundleIndex < bundleCount;) {
        SetCurResFile(workfileID);
        copyResource(rBundle, GetIndResource(rBundle, ++bundleIndex));

    }
}

/*--------------------------------------
	copyResource stolen from Foundation's magic.c

    Marc Wolfgram, 11/10/92 23:03:29
*/
void copyResource(word oldFile, word newFile, word resType, long resID)
{
word                i, offset, count, size, match, retVal;
Handle				resData, copyData;
Pointer             resPtr;
long                resSize;
wkPtr               srcPtr, tmpPtr;

    resData = LoadResource(resType, resID);

    resSize = GetHandleSize(resData);
    copyData = NewHandle(resSize, fMemID, 0x8008, 0L);
	HandToHand(resData, copyData, resSize);

    ReleaseResource(resType, resID);
	MoonCursor();

    resPtr = deref(copyData);

    switch (resType) {

    case rBundle:
		srcPtr.Ptr = resPtr;
		srcPtr.Ptr += 2;
		offset = *srcPtr.wPtr;   /* first we deal with the bundle header */
		srcPtr.Ptr += 2;
		copyResource(rIcon, *srcPtr.lPtr);
		srcPtr.Ptr = resPtr + offset;
		count = *srcPtr.wPtr;
    	srcPtr.Ptr += 2;            /* since we now have our header info */
		for (i = 0; i < count; i++) {
			size = *srcPtr.wPtr;
			tmpPtr.Ptr = srcPtr.Ptr + 4;
			match = *tmpPtr.wPtr;
			if (match > 1) {
				tmpPtr.Ptr = srcPtr.Ptr + 8;
				copyResource(rFinderPath, *tmpPtr.lPtr);
			}
			if (match > 2) {
				tmpPtr.Ptr = srcPtr.Ptr + 16;
				copyResource(rIcon, *tmpPtr.lPtr);
			}
			if (match > 3) {
				tmpPtr.Ptr = srcPtr.Ptr + 24;
				copyResource(rIcon, *tmpPtr.lPtr);
			}
			(long) srcPtr.Ptr += size;
		}
		break;

    case rFinderPath:
	    srcPtr.Ptr = resPtr;
		srcPtr.Ptr += 4;
        count = *srcPtr.wPtr;
        srcPtr.Ptr += 2;
        for (i = count; i > 0; i--) {
            copyResource(rVersion, *srcPtr.lPtr);
            srcPtr.Ptr += 8;
        }
		break;
    }

	HUnlock(copyData);

    SetCurResFile(desktopID);
    GetResourceAttr(resType, resID);
    if (toolerror == 0x1e06)
        AddResource(copyData, 0, resType, resID)

    MoonCursor();

    return resID;
}

/*--------------------------------------
	MoonCursor - better than a spinning beachball - maybe...

	Mark Collins,   1/ 2/92 23:25:01
	Marc Wolfgram,  1/28/92 23:46:36 fixed bit 31 trash-o-rama
*/
void MoonCursor(void)
{
word lastIndex;
long tick, mask;

	if ((tick = GetTick()) > moonTick) {
		lastIndex = (moonIndex) ? moonIndex -1 : 7;
		mask = ((long) GetCursorAdr() == moonPhase[lastIndex]) ? 0x80000000L : 0L;
		SetCursor(moonPhase[moonIndex++] | mask);
    	moonTick = tick + 10L;
    	moonIndex &= 7;
	}
}
